// ContentsToolView.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "IB.h"
#include "ContentsToolView.h"
#include "IBDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CContentsToolView

IMPLEMENT_DYNCREATE(CContentsToolView, CFormView)

CContentsToolView::CContentsToolView()
	: CFormView(CContentsToolView::IDD)
{
	//{{AFX_DATA_INIT(CContentsToolView)
		// : ClassWizard ͂̈ʒuɃȍǉ܂
	//}}AFX_DATA_INIT
	bCTViewActive = TRUE;
	pConnectDoc = NULL;
	nTreeIndex = FIRST_NODE_NUM;
	pHTreeItemList = NULL;
}

CContentsToolView::~CContentsToolView()
{
	delete propItem1;
	delete propItem2;
	delete propItem3;
	delete propItem4;
	delete propItem5;
	pConnectDoc = NULL;
	m_Font.DeleteObject();
	slNodePath.RemoveAll();
	if(pHTreeItemList)
	{
		delete [] pHTreeItemList;
		pHTreeItemList = NULL;
	}
}

void CContentsToolView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CContentsToolView)
	DDX_Control(pDX, IDC_CONTENTS_TREE, m_xmlTreeCtrl);
	DDX_Control(pDX, IDC_ELEMENT_LIST, m_elementList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CContentsToolView, CFormView)
	//{{AFX_MSG_MAP(CContentsToolView)
	ON_NOTIFY(TVN_SELCHANGED, IDC_CONTENTS_TREE, OnSelchangedContentsTree)
	//}}AFX_MSG_MAP
	ON_MESSAGE(MY_UPDATE_VIEW,OnUpdateView)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_CONTENTS_TREE, OnCustomDraw)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CContentsToolView ff

#ifdef _DEBUG
void CContentsToolView::AssertValid() const
{
	CFormView::AssertValid();
}

void CContentsToolView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG



/////////////////////////////////////////////////////////////////////////////
// CContentsToolView bZ[W nh

void CContentsToolView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();

	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	propItem1 = new CPropertyItem("ToolTip Text","",PIT_EDIT,"");
	m_elementList.AddPropItem(propItem1);

	propItem2 = new CPropertyItem("Enabled","true",PIT_COMBO,"true|false|");
	m_elementList.AddPropItem(propItem2);

	propItem3 = new CPropertyItem("Visible","true",PIT_COMBO,"true|false|");
	m_elementList.AddPropItem(propItem3);

	propItem4 = new CPropertyItem("Fore. Color","",PIT_COLOR,"");
	m_elementList.AddPropItem(propItem4);

	propItem5 = new CPropertyItem("","",PIT_INIT,"");
	m_elementList.AddPropItem(propItem5);
	m_elementList.AddPropItem(propItem5);
	m_elementList.AddPropItem(propItem5);
	m_elementList.AddPropItem(propItem5);
	m_elementList.AddPropItem(propItem5);
	m_elementList.AddPropItem(propItem5);

	if(m_Font.m_hObject != NULL)
		m_Font.DeleteObject();
	m_Font.CreatePointFont(105,"lr pSVbN");
	m_xmlTreeCtrl.SetFont(&m_Font);
	m_xmlTreeCtrl.SetTextColor(0xff0000);

	m_Imagelist.Create(IDB_TREEIMAGES, 16, 1, RGB(255,0,255));
	m_xmlTreeCtrl.SetImageList(&m_Imagelist,TVSIL_NORMAL);
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();
}

void CContentsToolView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if(bActivate)
	{
		bCTViewActive = TRUE;    //ANeBu
	}
	else
		bCTViewActive = FALSE;   //ANeBu

	CFormView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

void CContentsToolView::OnDraw(CDC* pDC) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	TRACE("ContentsToolViewOnDrawĂ΂ꂽ\n");	
	//hLgƂ̊֘At܂łĂȂƂNULLԂĂ

//	InvalidateRect(NULL);
}

BOOL CContentsToolView::PreCreateWindow(CREATESTRUCT& cs) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	cs.style |= TVS_SHOWSELALWAYS;
	return CFormView::PreCreateWindow(cs);
}

void CContentsToolView::OnSelchangedContentsTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NMTREEVIEW* pNMTreeView = (NMTREEVIEW*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	TVITEMA tvi;
	tvi.mask = TVIF_TEXT | TVIF_PARAM;
	tvi = pNMTreeView->itemNew;

	IXMLDOMNode *pSelectNode = NULL;
	POSITION pos = slNodePath.FindIndex((int)tvi.lParam);
	if(pConnectDoc)
	{
		if(pConnectDoc->m_xmlData.GetDOMNodeItem(slNodePath.GetAt(pos),&pSelectNode) == 0)
		{
			BSTR bstrName;
			pSelectNode->get_nodeName(&bstrName);
			TRACE("%d: %sI\n\n",tvi.lParam,CString(bstrName));
			SysFreeString(bstrName);
		}
	}
	*pResult = 0;
}

LRESULT CContentsToolView::OnUpdateView(WPARAM wParam,LPARAM lParam)
{
//	if(!bCTViewActive) return 0;

	TRACE("ContentsToolViewOnUpdateViewĂ΂ꂽ\n");

	pConnectDoc = (CIBDoc*)wParam;
	//xmlt@CJĂȂ
	GetTagTree(pConnectDoc);
	InvalidateRect(NULL);

	return 0;
}

void CContentsToolView::SetConnectDoc(CIBDoc *pDoc)
{
	pConnectDoc = pDoc;
}


//JX^h[FڂƂ̕`
void CContentsToolView::OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult)
{
	NMTVCUSTOMDRAW*  lpCustomDraw = (NMTVCUSTOMDRAW*)pNMHDR;

    if( lpCustomDraw->nmcd.dwDrawStage == CDDS_PREPAINT )
    {
        //  ACe`ł悤ɂ
        *pResult = CDRF_NOTIFYITEMDRAW;
        return;
    }
	//  ACe`悳鎞ɂɂ
    if( lpCustomDraw->nmcd.dwDrawStage == CDDS_ITEMPREPAINT )
    {
		if(lpCustomDraw->nmcd.lItemlParam == -1)
		{
			//  eLXgFݒ
			lpCustomDraw->clrText = RGB(255,255,255);
			//  wiFݒ
			lpCustomDraw->clrTextBk = RGB(0,0,0);
		}
        *pResult = 0;
        return;
     }
    
    *pResult = 0;
}


/******************************************************************************************
 ֐		: void CDOMCtrl::GetTagTree(CTreeCtrl *pTree)
 @\		: XML̃^O\c[r[ɕ\
 		: *pTree --------@\c[r[Rg[̃|C^
 ߂l		: Ȃ
 쐬		: @TH
 쐬		: 2001/09/06
 ******************************************************************************************/
void CContentsToolView::GetTagTree(CIBDoc *pDoc)
{
	m_xmlTreeCtrl.DeleteAllItems();

	if(pDoc == NULL)
		return;

	if(pHTreeItemList)
	{
		delete [] pHTreeItemList;
		pHTreeItemList = NULL;
	}
	slNodePath.RemoveAll();

	IXMLDOMNode *pNode;
	pDoc->m_xmlData.m_pAllNodeList->get_item(0,&pNode);

	long lLen;
	pDoc->m_xmlData.m_pAllNodeList->get_length(&lLen);

	nTreeIndex = 0;
	pHTreeItemList = new HTREEITEM [(int)lLen+1];

	InsertTagName(TVI_ROOT,pNode,0,"");
	TRACE("c[\III::\n");
}

/******************************************************************************************
 ֐		: void CDOMCtrl::InsertTagName(CTreeCtrl *pTree, HTREEITEM hParent,
							 IXMLDOMNode *pNode)
 @\		: ċNIɗvfm[hc[ɓo^
 		: *pTree --------@\c[r[Rg[̃|C^
			@hParent--------  eڂ̃nh
			@pNode  --------  o^vfm[h
 ߂l		: Ȃ
 쐬		: @TH
 쐬		: 2001/09/011
 ******************************************************************************************/
void CContentsToolView::InsertTagName(HTREEITEM hParent,IXMLDOMNode *pNode,
							 int nChildNum,LPCTSTR lpszPath)
{
	HRESULT hr = S_OK;
	IXMLDOMNodeList *pChildNList;
	BSTR bstrName;

	IXMLDOMNode *pNextNode = NULL;
	DOMNodeType nodetype;

	//c[ɓo^ׂ̕ϐ
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	CString strName;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	long llen;
	VARIANT_BOOL vbHasChild;
	try
	{
		while(pNode)
		{
			CString strPath = lpszPath;
			pNode->get_nodeType(&nodetype);
			if(nodetype == NODE_ELEMENT)
			{
				//vf擾
				pNode->get_nodeName(&bstrName);
				strName = bstrName;
				SysFreeString(bstrName);

				//m[hɑΉpX\L
				char cNum[20];
				_itoa(nChildNum,cNum,10);
				strPath += "/*[";
				strPath = strPath + cNum ;
				strPath += "]";

				slNodePath.AddTail(strPath);
				//c[ɓo^
				tvi.pszText = strName.GetBuffer(strName.GetLength());
				tvi.lParam = nTreeIndex;
				tvi.iImage = 0;
				tvi.iSelectedImage = 1;
				tvs.item = tvi;
				hParent = m_xmlTreeCtrl.InsertItem(&tvs);
				pHTreeItemList[nTreeIndex] = hParent;
				nTreeIndex++;
				
				TRACE("%d::vf@%s@ǉ:%x\n",nTreeIndex,strName,pNode);
			}
			//qm[h݂邩H
			pNode->hasChildNodes(&vbHasChild);
			if(vbHasChild)
			{
				//qm[hXg擾
				hr = pNode->get_childNodes(&pChildNList);
				if(hr != S_OK){throw -1;}

				pChildNList->get_length(&llen);
				int nChildNum = 0;
				for( int i=0; i<(int)llen; i++)
				{
					hr = pChildNList->get_item(i, &pNextNode);
					if(hr != S_OK){throw -2;}
					
					pNextNode->get_nodeType(&nodetype);
					//qm[hvfȂc[ɓo^
					if(nodetype == NODE_ELEMENT)
					{
						InsertTagName(hParent,pNextNode,nChildNum,strPath);
						nChildNum++;
					}
					//GeBeBQƂĂȂCWJ
					else if(nodetype == NODE_ENTITY_REFERENCE)
					{
						IXMLDOMEntityReferencePtr spEntity;
						hr = pNextNode->QueryInterface(IID_IXMLDOMEntityReference,(void**)&spEntity);
						if(hr != S_OK){throw -3;}
						spEntity->hasChildNodes(&vbHasChild);
						if(vbHasChild)
						{
							IXMLDOMNodeListPtr spEntityList;
							hr = spEntity->get_childNodes(&spEntityList);
							if(hr != S_OK){throw -4;}
							long lEntityLen;
							spEntityList->get_length(&lEntityLen);
							for( int i=0; i<(int)lEntityLen; i++)
							{
								hr = spEntityList->get_item(i, &pNextNode);
								if(hr != S_OK){throw -2;}
					
								pNextNode->get_nodeType(&nodetype);
								//qm[hvfȂc[ɓo^
								if(nodetype == NODE_ELEMENT)
								{
									InsertTagName(hParent,pNextNode,nChildNum,strPath);
									nChildNum++;
								}
							}
						}
					}
				}
				//m[h̊J
				ReleaseObj(pChildNList);
			}
			//m[h̊J
			ReleaseObj(pNode);
		}
	}
	catch(int nCode)
	{
				// G[
		char *pMsg;
		switch ( nCode ) {
			case -1 : { pMsg = "CreateDOMInstance : Can't Create Instance"; break; }
			case -2 : { pMsg = "CreateDOMInstance : Failed to load xml file!"; break; }
			default : { pMsg = "CreateDOMInstance : Unknown error code!"; break; }
		}
		return;
	}
}
